﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Notatnik.NET_2014
{
    public partial class Form1 : Form
    {
        bool czyZmienionyTekst = false;

        public Form1()
        {
            InitializeComponent();
        }

        string ścieżkaPliku = "";

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = ścieżkaPliku;
            DialogResult dr = openFileDialog1.ShowDialog();
            if(dr == DialogResult.OK)
            {
                try
                {
                    //textBox1.Lines = PlikiTekstowe.CzytajPlikTekstowy(openFileDialog1.FileName);
                    textBox1.CzytajZPliku(openFileDialog1.FileName);
                    ścieżkaPliku = openFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Wczytano plik '" + Path.GetFileName(ścieżkaPliku) + "'";
                    statusStrip1.BackColor = Color.Green;
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    czyZmienionyTekst = false;
                }
                catch(Exception exc)
                {
                    toolStripStatusLabel1.Text = exc.Message;
                    statusStrip1.BackColor = Color.Red;
                }
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveFileDialog1.FileName = ścieżkaPliku;
            saveFileDialog1.FilterIndex = openFileDialog1.FilterIndex;
            if(toolStripStatusLabel1.Text!="" && toolStripStatusLabel1.Text!=null)
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(toolStripStatusLabel1.Text);
            saveFileDialog1.FileName = Path.GetFileName(toolStripStatusLabel1.Text);            
            DialogResult dr = saveFileDialog1.ShowDialog();
            if(dr == DialogResult.OK)
            {
                try
                {
                    PlikiTekstowe.ZapiszDoPlikuTekstowego(saveFileDialog1.FileName, textBox1.Lines);
                    ścieżkaPliku = saveFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Zapisano do pliku '" + Path.GetFileName(ścieżkaPliku) + "'";
                    statusStrip1.BackColor = Color.Green;
                    czyZmienionyTekst = false;
                }
                catch(Exception exc)
                {
                    toolStripStatusLabel1.Text = exc.Message;
                    statusStrip1.BackColor = Color.Red;
                }
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if(colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //pasekStanuToolStripMenuItem.Checked = !pasekStanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!czyZmienionyTekst) return;

            DialogResult dr = MessageBox.Show(
                "Czy zapisać tekst przed zamknięciem?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button3);
            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszJakoToolStripMenuItem_Click(sender, null);
                    break;
                case DialogResult.No:                    
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
            }  
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            czyZmienionyTekst = true;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (toolStripStatusLabel1.Text != "" && toolStripStatusLabel1.Text != null)
                PlikiTekstowe.ZapiszDoPlikuTekstowego(toolStripStatusLabel1.Text, textBox1.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, null);
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();            
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }
    }


    static class Rozszerzenia
    {
        public static bool CzytajZPliku(this TextBox textBox, string ścieżkaPliku)
        {
            try
            {
                textBox.Lines = PlikiTekstowe.CzytajPlikTekstowy(ścieżkaPliku);
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}
